//DrawFloorTwo.scad;

//This is version 2022_03_11;

//The case has two floors:

//The lower floor carries the holes for 
//the mounting screws and magnets, 
//but does not carry the mounting posts 
//for the electronic components;

//The upper floor carries the mounting 
//posts for the electronic components;
//The holes in these posts extent right thru 
//the floor and are tapped right thru too;
//This simplifies the tapping;

//All holes in the mounting posts 
//are PostTapPhi = 2.5mm, 
//ready to be tapped for a 3mm screw;

//This is FloorTwo, the upper floor;

include <BATT_Dimensions.scad>;
use <BATT_Floor.scad>;
use <BATT_FloorMountingPosts.scad>;
use <BATT_FloorMountingPostHoles.scad>;
use <BATT_FloorMagnetRecesses.scad>;
use <BATT_LidScrewThreads.scad>;

ThreadHole = LidScrewThreadPhi +Whisker;

//color("Blue") LidScrewThreads(ThreadHole, 6);

difference()
{
    Floor();
    LidScrewThreads(ThreadHole, 6);
    FloorMountingPostHoles();
    translate([0, 0, -FloorZ])
    FloorMagnetRecesses();
}

//color("Blue") FloorMountingPostHoles();

difference()
{
    FloorMountingPosts();
    FloorMountingPostHoles();
}

//
